"""
Name-US:Disable SDS
Description-US:Ctrl-click [enable] - Enable/disable all the SDS objects in your scene...

"""
import c4d
from c4d import documents

###########################################################################
#Turns off all Subdivision Surfaces. Turn them back on with CTRL modifier.#
########################################################################### 
#Written by Andrew Runyon
#Icon by Can Erduman

def GetNextObject(op):
    """
    This function loops through every object in the scene
    """
    if op==None: return None
 
    if op.GetDown(): return op.GetDown()
 
    while not op.GetNext() and op.GetUp():
      op = op.GetUp()
 
    return op.GetNext()

def mod_key():
    """
    This function outputs the user's modifier key (ALT or CTRL)
    """

    bc = c4d.BaseContainer()
    if c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD,c4d.BFM_INPUT_CHANNEL,bc):
      
      if bc[c4d.BFM_INPUT_QUALIFIER] & c4d.QCTRL:
        return "CTRL"
    return

def main():
    doc.StartUndo()
    
    #Add undo 
    myobject = doc.GetFirstObject()
    while myobject:
      doc.AddUndo(c4d.UNDOTYPE_CHANGE_SMALL, myobject)
      myobject = GetNextObject(myobject)     
    #If Control key is depressed turn on all Subdivision Surfaces
    if mod_key() == "CTRL":
      myobject = doc.GetFirstObject() 
      while myobject: 
        if myobject.GetTypeName() == "Subdivision Surface":
          myobject[c4d.ID_BASEOBJECT_GENERATOR_FLAG] = 1
        myobject = GetNextObject(myobject)
      
      c4d.EventAdd()
      return
    
    #Else turn off all Subdivision Surfaces
    if mod_key() != "CTRL": 
      myobject = doc.GetFirstObject()
      while myobject: 
        if myobject.GetTypeName() == "Subdivision Surface":
          myobject[c4d.ID_BASEOBJECT_GENERATOR_FLAG] = 0
        myobject = GetNextObject(myobject)
    

    c4d.EventAdd()      
    doc.EndUndo()        
    
if __name__=='__main__':
    main()